﻿#include  "StdAfx.h"
#include  <strsafe.h>
#include  <szRuntimeException.hpp>

using namespace szpp;

bool GetFileName(HWND hWndParent, szchar *lpszFileName, u32 size, const szchar *lpszTitle, const szchar *lpszFilter, u32 flags)
{
  OPENFILENAME ofn;
  memset(&ofn, 0, sizeof(OPENFILENAME));

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hWndParent;
  ofn.lpstrFilter = lpszFilter;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = lpszFileName;
  ofn.nMaxFile = size;
  ofn.lpstrTitle = lpszTitle;
  ofn.Flags = flags;

  if (0 == GetSaveFileName(&ofn))
  {
    // CommDlgExtendedError が 0 なら単にキャンセルされただけ。0 以外ならエラー。
    if (CommDlgExtendedError())
      BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot get the archive file name")));
    return false;
  }

  return true;
}

void CreateFilterString(szchar *lpszFilters, u32 size, const szchar *lpszOriginalFilters)
{
  u32 length = lstrlen(lpszOriginalFilters);
  if (size < length)
  {
    if (size > 0 && 0 != lpszFilters)
      lpszFilters[0] = SZL('\0');
    return;
  }

  StringCchCopy(lpszFilters, size, lpszOriginalFilters);
  for (u32 i = 0; i < length; ++i)
    if (lpszFilters[i] == SZL('|'))
      lpszFilters[i] = SZL('\0');
}
